IF EXISTS( SELECT 1   FROM sys.objects    WHERE object_id = OBJECT_ID(N'[dbo].[GLB_CONCORRENCIA_PRC_FILIAL]')       AND type IN ( N'U' )
)
BEGIN
    --- cross join traz todas as linhas das duas tabelas independete do vinculo
    INSERT INTO GLB_CONCORRENCIA_PRC_FILIAL ( CD_EMP, CD_FILIAL, CD_CONCOR  )
    SELECT * FROM (
        SELECT a.CD_EMP,
               f.CD_FILIAL,
               a.CD_CONCOR
        FROM GLB_CONCORRENCIA a
            CROSS JOIN PRC_FILIAL f
    ) AS T
    WHERE NOT EXISTS
    (
        SELECT 1
        FROM GLB_CONCORRENCIA_PRC_FILIAL B
        WHERE T.CD_EMP = B.CD_EMP
              AND T.CD_FILIAL = B.CD_FILIAL
              AND T.CD_CONCOR = B.CD_CONCOR
    )
    ORDER BY T.CD_EMP,
             T.CD_FILIAL,
             T.CD_CONCOR;
END;

